#!/bin/bash

source .env.sh

# Start miniOrange Services

startServices() {
    echo "Enter 'start' or 'restart':"
    read input
    if [ "$input" = "start" ]; then
        echo 'Starting services...'
        
        echo "Starting config service..."
        systemctl start mo-idp-configserver.service
        echo "Waiting for 10 seconds after ConfigServer..."
        sleep 20

        echo "Starting Eureka service..."
        systemctl start mo-idp-eurekaserver.service
        echo "Waiting for 10 seconds after Eureka Server..."
        sleep 10

        echo "Starting Gatekeeper service..."
        systemctl start mo-idp-gatekeeper.service

        echo "Waiting for 10 seconds after Gatekeeper..."
        sleep 20

        echo "Starting apps service..."
        systemctl start mo-idp-apps.service

        echo "Starting auditing service..."
        systemctl start mo-idp-auditing.service
        
        echo "Starting provisioning service..."
        systemctl start mo-idp-provisioning.service

        echo "Starting directory service..."
        systemctl start mo-idp-directory.service

        echo "Starting scheduler service..."
        systemctl start mo-idp-scheduler.service

        echo "Starting siem service..."
        systemctl start mo-idp-siem.service

        echo "Starting workflow service..."
        systemctl start mo-idp-workflow.service
        
    elif [ "$input" = "restart" ]; then
        echo 'Restarting services'
        
        echo "Restarting config service..."
        systemctl restart mo-idp-configserver.service
        
        echo "Waiting for 10 seconds after config restart..."
        sleep 20
        
        echo "Restarting Eureka service..."
        systemctl restart mo-idp-eurekaserver.service
        
        echo "Waiting for 10 seconds after EurekaServer restart..."
        sleep 10

        echo "Restarting Gatekeeper service..."
        systemctl restart mo-idp-gatekeeper.service
        
        echo "Waiting for 10 seconds after Gatekeeper restart..."
        sleep 20
        
        echo "Restarting apps service..."
        systemctl restart mo-idp-apps.service
        
        echo "Restarting auditing service..."
        systemctl restart mo-idp-auditing.service
        
        echo "Restarting provisioning service..."
        systemctl restart mo-idp-provisioning.service

        echo "Restarting directory service..."
        systemctl restart mo-idp-directory.service

        echo "Restarting scheduler service..."
        systemctl restart mo-idp-scheduler.service

        echo "Restarting siem service..."
        systemctl restart mo-idp-siem.service

        echo "Restarting workflow service..."
        systemctl restart mo-idp-workflow.service

    else
        echo "Invalid argument. Use 'start' or 'restart'."
        exit 1
        
    fi
}

registerScheduler() {
	echo "Registering Scheduler..."
	chmod +x $moIdpFolderName/services/linux/scheduler-mq-register.sh
	sh $moIdpFolderName/services/linux/scheduler-mq-register.sh
}

startServices